/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * 
 * $Id: PersistenceTest.scala 817 2008-01-25 19:44:05Z ms $
 */
package ch.ethz.inf.sct.uts.test

import ch.ethz.inf.sct.uts.test.helpers._

import java.io.File
import java.io.PrintWriter
import scala.testing.SUnit
import SUnit._

/**
 * Test if the annotations are stored persistently in the classfile.
 * 
 * @author  Manfred Stock
 * @version $Revision: 817 $
 */
object PersistenceTest extends TestUtils {
	
  def main(args: Array[String]) {
    /**
     * Files with content.
     */
    val files = List(
    ("A", 0, """
import ch.ethz.inf.sct.uts.annotation._

class A {
	val a = new (A @rep)
  val b = new (A @peer)
}
"""),
("B", 2, """
import ch.ethz.inf.sct.uts.annotation._
	
class B {
  val a            = new (A @rep)
  val b            = a.a
  val b2 : A @any  = a.a
  // Not ok
  val b3 : A @rep  = a.a
  val c            = a.b
  val c2 : A @rep  = a.b
  
  val d            = new (A @peer)
  val e            = d.a
  val e2 : A @any  = d.a
  // Not ok
  val e3 : A @peer = d.a
  val f            = d.b
  val f2 : A @peer = d.b
}
"""
    ))
    
    /** Directory where the sources should be stored. */
    val indir = new File("target/persistence-sources/")
    indir.mkdirs
    /** Directory where the compiled files should be stored. */
    val outdir = new File("target/persistence-classes/")
    outdir.mkdirs
    // Compile the files.
    files foreach {
      case (name,errors,content) => {
        val file = new File(indir.getPath+"/"+name+".scala")
        val out = new PrintWriter(file)
        if (out != null) {
          out.print(content)
          out.close
        }
    
        /** TestRunner to compile the sources. */
        object testRunner extends TestRunner {
          /**
       	 	 * Factory to create the actual test cases from the test data.
       	   */
       	  object CompilationTestFactory extends CompilationTestFactory {
            val options : List[String] = List("-P:uts-static:oam","-P:uts-static:ast","-P:uts-static:loglevel=info") ::: args.toList
            val plugins : List[String] = List("target/uts-static.jar")
            val destination : String = outdir.getPath+"/"
            val srcdir : String = indir.getPath+"/"
          }
  
          /**
           * Testdata - a list with classname, expected error/warning count and a name for the test case.
       	   */
       	  val testdata = List(
       	    (name, errors, 0, name)
       	  )
         
          /**
     	     * Create a testsuite with the tests that should be executed.
     	     * @return the created testsuite.
     	     */
     	    def suite = {
            val suite = new TestSuite
            testdata foreach {
              case (cls: String, errors, warnings, name) => suite.addTest(CompilationTestFactory.produce(cls,errors,warnings,name))
            }
            suite
          }
        }
        testRunner.main(args)
        file.delete
      }
    }
  }
}
