/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * 
 * $Id: PolicyBase.scala 817 2008-01-25 19:44:05Z ms $
 */
package ch.ethz.inf.sct.uts.rt;

/**
 * Base for the policies to use during Universe type system runtime checks.
 * 
 * @author  Manfred Stock
 * @version $Revision: 817 $
 */
trait PolicyBase {
  /**
   * Defines the default owner for Universe type system aware Objects that
   * are created from outside of Universe type system aware code.
   * 
   * If null is returned, the implementation should default to something
   * reasonable (like registering the object peer with regards to the last
   * object).
   * @param obj The object that needs an owner.
   * @return    the owner.
   */
  def getNativeOwner(obj: AnyRef) : AnyRef 
        
  /**
   * Defines what to do when a reference to the owner is requested and
   * the owner has already been collected.
   * @param obj The Object whose owner has already been collected
   *            but is now requested.
   * @return    the object to use as owner of <code>obj</code>.
   */ 
  def getCollectedOwner(obj: AnyRef) : AnyRef
        
  /**
   * Defines how external objects (from non-universe type system aware code) are
   * handled. i.e. if they should be treated as being "peer".
   * @return  true if external objects should be handled as being peer
   */
  def isExternalPeer : Boolean
  
  /**
   * Handles an illegal cast to a @rep instance.
   */ 
  def illegalRepCast {
    throw new ClassCastException("Cannot cast an object owned by some other object to a rep reference.")
  }
   
  /**
   * Handles an illegal cast to a @peer instance.
   */ 
  def illegalPeerCast {
    throw new ClassCastException("Cannot cast an object which has an owner that is different from the owner of 'this' to a peer reference.")    
  }
}
