/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * 
 * $Id: UTSUnchecked.scala 883 2008-02-01 18:59:56Z ms $
 */
package ch.ethz.inf.sct.uts.annotation

/**
 * Annotation to tell the universe type system checker that a given class should not be checked.
 * Could eg. be useful as long as the whole Scala base library is not annotated. 
 * @note This only prevents explicit checks of classes with this annotation - if some external
 *       code currently being compiled uses methods, fields, etc. from the annotated class, the respective
 *       code will be typechecked nevertheless, including code in the class which it depends on.
 * 
 * @author  Manfred Stock
 * @version $Revision: 883 $
 */
case class UTSUnchecked extends StaticAnnotation
