/*
 * This file is part the Universe Runtime Classes.
 *
 * Copyright (C) 2003-2005 Swiss Federal Institute of Technology Zurich
 *
 * Part of mjc, the MultiJava Compiler.
 *
 * Copyright (C) 2000-2005 Iowa State University
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: UrtDebug.java,v 1.2 2005/06/28 20:56:08 wdietl Exp $
 */

package org.multijava.universes.rt.impl;

import org.multijava.universes.rt.UrtImplementation;

/**
 * Alternative implementation of UrtDefaultImplementation that prints debug
 * information to stdout before it calls the respective method of
 * UrtDefaultImplementation.
 * 
 * @author scdaniel
 */
public class UrtDebug
    extends UrtDefaultImplementation
    implements UrtImplementation {

    public void setOwnerRep (Object obj, Object owner) {
	System.out.println("setOwnerRep: " + obj + ", " + owner);
	super.setOwnerRep(obj, owner);
    }

    public void setOwnerPeer (Object obj, Object current) {
	System.out.println("setOwnerPeer: " + obj + ", " + current);
	super.setOwnerPeer(obj, current);
    }

    public void setConstructorData (Object currentObject, Object objectClass,
				    int modifier) {
	System.out.println("setConstructorData: " + currentObject + ", " +
			   objectClass + ", " + modifier);
	super.setConstructorData(currentObject, objectClass, modifier);
    }
	
    public void setOwner (Object o) {
	System.out.println("setOwner: " + o);
	super.setOwner(o);
    }
	
    public void setArrayOwnerRep (Object obj, Object owner,
				  int arrayElementType) {
	System.out.println("setArrayOwnerRep: " + obj + ", " + owner + ", " +
			   arrayElementType);
	super.setArrayOwnerRep(obj, owner, arrayElementType);
    }
    
    public void setArrayOwnerPeer (Object obj, Object current,
				   int arrayElementType) {
	System.out.println("setArrayOwnerPeer: " + obj + ", " +
			   current + ", " + arrayElementType);
	super.setArrayOwnerPeer(obj, current, arrayElementType);
    }
	
    public boolean isPeer (Object o1, Object o2) {
	System.out.println("isPeer: " + o1 + ", " + o2);
	return super.isPeer(o1, o2);
    }
	
    public boolean isOwner (Object owner, Object obj) {
	System.out.println("isOwner: " + owner + ", " + obj);
	return super.isOwner(owner, obj);
    }

    public boolean checkArrayType (Object o, int elementType) {
	System.out.println("checkArrayType: " + o + ", " + elementType);
	return super.checkArrayType(o, elementType);
    }
	
    public Object getOwner (Object obj) {
	System.out.println("getOwner: " + obj);		
	return super.getOwner(obj);
    }

    public Object getRootSetMember () {
	System.out.println("getRootSetMember");
	return super.getRootSetMember();
    }
	
    public void setContext (Object currentObject) {
	System.out.println("setContext: " + currentObject);
	super.setContext(currentObject);
    }
	
    public void resetContext () {
	System.out.println("resetContext");
	super.resetContext();
    }
	
    public Object getContext () {
	System.out.println("getContext");
	return super.getContext();
    }
}
