package ch.ethz.inf.sct.uts.examples.static

import ch.ethz.inf.sct.uts.annotation._

class IfThenElse2 {
	
  // Ok
  val a : A @any = if (true) {
    new B @rep
  }
  else {
    new C @peer
  }
  
  // Not ok
  val b : A @rep = if (true) {
    new B @rep
  }
  else {
    new C @peer
  }

  // Not ok
  val c : A @peer = if (true) {
    new B @rep
  }
  else {
    new C @peer
  }
  
  // Ok
  if (true) {
    new B @rep
  }
  else {
    new C @peer
  }
  
  // Ok
  if (true) {
    new A
  }
  else {
    new B
  }
  
  // Not ok
  var x = new (A @rep)
  x = if (true) {
    new B @peer
  }
  else {
    new C @rep
  }
  
  // Ok
  if (true) {
    new A
  }
  else {
    new C
  }
  
  // Ok
  if (true) {
    new B
  }
  else {
    new B
  }
  
  class A
  
  class B extends A
  
  class C extends A
  
  // Ok
  class X[S,T](a: S, b: T) {
    if (true) {
      a
    }
    else {
      b
    }
  }
}
