package ch.ethz.inf.sct.uts.examples.collection.map

import ch.ethz.inf.sct.uts.annotation._

class MapNode[K, V, X <: MapNode[K,V,X] @any] () {
  private var nodekey: K = _
  private var nodevalue: V = _
  private var nextnode: X = _
        
  def init(key: K, value: V, next: X) {
    nodekey = key
    nodevalue = value
    nextnode = next 
  }
        
  @pure def getKey: K = nodekey 
  @pure def getValue: V = nodevalue
  def setValue(value: V) = nodevalue = value
  @pure def getNext: X = nextnode
}
