package utsdemo

// Import the annotations
import ch.ethz.inf.sct.uts.annotation._

// Application which creates a new instance of class C
object Main extends Application {
  new (C @rep)
}

// An example class which uses ownership modifiers
class C {
  // Use the annotations
  val a = new (Cls @rep)
  var b : Cls @any = new (Cls @rep)
  val c = new (Cls @peer)
  b = c
  
  // More complex example with annotations on the type arguments,
  // the type and the constructor argument.
  val d = new (Generic[Cls @any] @rep)(new (Cls @rep))
  b = d.field

  // Print a message to say that initialization is done
  println("Done.")
}

class Cls

class Generic[T <: Any @any](a: T) {
  val field = a
}
