package ch.ethz.inf.sct.uts.plugin
import scala.tools.nsc._
import scala.tools.nsc.plugins._

/** Compiler plugin for the Scala compiler. */
class Plugin1(val global: Global) extends Plugin {
  /** Name of this plugin. */
  val name = "plugin1"
    
  /** Description of this plugin. */
  val description = "Compiler plugin 1."

  /** Components of this plugin. */
  val components = List(new Plugin1Component(global))
  
  /** A description of this plugin's options, for -help. */
  override val optionsHelp: Option[String] = Some(description)
}

/** Plugin component which runs after runsAfter. */
class Plugin1Component (val global: Global) 
  extends PluginComponent {
  import global._
  /** Name of this compiler phase. */
  val phaseName = "plugin1"
      
  /** When to execute this phase. */
  val runsAfter = "refchecks"
      
  /** Factory to create the new phase for the graph generation. */
  def newPhase(prev: Phase) = new Phase(prev) {
    def name = phaseName
      
    /** Process the compilation units. */
    def run {
      println(name+" done.")
    }
  }
}
