
TEXDEPENDENCIES=$(shell find . \( -name "*.tex" -o -name "*.bbl" \) -a ! -name ".*") 
TEXINPUTS=$(shell find . -type d -a ! -name "CVS" ! -path "*.svn*" -exec echo -n \{\}: \;):../common
SUBDIRS=$(shell for i in */Makefile ; do if [ -f $$i ] ; then echo $$(dirname $$i) ; fi; done)
IMAGES=$(shell find */ -type f -a \( -name "*.pdf" -o -name "*.ps" -o -name "*.eps" \) -a ! -name $(BASEFILE).pdf -a ! -name $(BASEFILE).ps -a ! -name booklet.ps -a ! -name $(BASEFILE)-2x1.pdf)

# be aware that -halt-on-error does not work on older versions of pdflatex...
LTXOPTS=-halt-on-error 

LATEX=latex
PDFLATEX=$(shell if [ -x /usr/sepp/bin/pdflatex-3.0 ] ; then echo pdflatex-3.0 ; else echo pdflatex ; fi)
PDFVIEWER=xpdf
PDFVIEWEROPTS += -z page

UNDEFCIT='^LaTeX Warning: Citation .* undefined .*' 
RERUN='(LaTeX Warning: .* Rerun to get cross-references right.|pdfTeX warning \(dest\): .* has been referenced)'
ERRORS='(Warning|Error|Overfull|Underfull|undefined)'

define copy
		if test -r $(1).toc; then cp $(1).toc $(1).toc.bak; else touch $(1).toc.bak; fi
endef

define run-latex
		echo "Executing $(1) with $<..."
		$(call copy,$(2))
		TEXINPUTS=${TEXINPUTS} $(1) ${LTXOPTS} $< >$(2).stdout
		if [ ! -r $(2).toc ] ; then touch $(2).toc; fi
		egrep -i $(ERRORS) $(2).log || true
		if egrep $(UNDEFCIT) $(2).log >/dev/null; then bibtex $(2) ; fi
		count=0;\
		while egrep ${RERUN} $(2).log >/dev/null || grep ${UNDEFCIT} $(2).log >/dev/null || ! cmp -s $(2).toc $(2).toc.bak; do \
			$(call copy,$(2)); \
			TEXINPUTS=${TEXINPUTS} $(1) ${LTXOPTS} $< >$(2).stdout; \
			egrep -i $(ERRORS) $(2).log || true; \
			if [ $$count -ge 1 ] && egrep ${UNDEFCIT} $(2).log >/dev/null; then \
				exit 1; \
			fi; \
			count=$$((count+1)); \
		done
		rm -fv $(2).toc.bak
		echo "Done."
endef

.PHONY: all ps exerptview view macview clean subdirs $(SUBDIRS) 2up booklet

all: ${BASEFILE}.pdf

bibtex: ${BASEFILE}.bbl
		bibtex ${BASEFILE}

ps: ${BASEFILE}.ps

subdirs: $(SUBDIRS)

$(SUBDIRS):
		$(MAKE) -C $@

%.pdf: %.tex $(TEXDEPENDENCIES) $(IMAGES) $(COMMONDEPENDENCIES)
		@$(call run-latex,$(PDFLATEX),$(subst .tex,,$<))

%.ps: %.pdf
		pdftops -paper A4 $< $@ 

%-1.pdf: %.mp
		if [ -f $$(dirname $<)/Makefile ] ; then $(MAKE) -C $$(dirname $<) ; fi

exerptview:
		echo "\input{head}\input{commands}\graphicspath{{measurements/}}\begin{document}\input{${EXERPT}}\end{document}" > exerpt.tex
		pdflatex exerpt.tex
		${PDFVIEWER} ${PDFVIEWEROPTS} exerpt.pdf ${XPDFPAGE}

2up: ${BASEFILE}.pdf
		pdfnup --nup 2x1 --openright true junit-testgen.pdf

booklet: ${BASEFILE}.ps
		psbook $< | psnup -pA4 -2 > $@.ps

view: ${BASEFILE}.pdf
		${PDFVIEWER} ${PDFVIEWEROPTS} $< ${XPDFPAGE}

macview: ${BASEFILE}.pdf
		open $<

clean:
		rm -vrf *.aux *.dvi *.toc *.log *~ *.ps *.lof *.lot *.out *.lol *.bbl *.blg booklet.ps ${BASEFILE}-2x1.pdf *.snm *.nav *.stdout *.toc.bak *.cache *.state *.eps

