/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * 
 * $Id: UTSRTTest.scala 883 2008-02-01 18:59:56Z ms $
 */
package ch.ethz.inf.sct.uts.test

import scala.tools.nsc.Main

import scala.testing.SUnit
import SUnit._

//import ch.ethz.inf.sct.uts.rt._
import ch.ethz.inf.sct.uts.test.helpers._

/**
 * Object used to execute some kind of unit-tests. The tests consist of an attempt to compile 
 * given source code and a comparison of the result (i.e. number of errors and warnings) to the 
 * expected values. The compiled classes are executed afterwards.
 * 
 * @author  Manfred Stock
 * @version $Revision: 883 $
 */
object UTSRTTest extends TestUtils with TestRunner {  
  /**
   * Factory to create the actual test cases for the compilation.
   */
  object CompilationTestFactory extends CompilationTestFactory {
    val options : List[String] = List("-P:uts-static:oam")
    val plugins : List[String] = List("target/uts-static.jar","target/uts-runtime.jar")
    val destination : String = "target/example-classes"
    val srcdir : String = "src/examples/scala/"
  }
  
  /**
   * Factory to create the actual test cases for the execution of compiled classes.
   */
  object ExecutionTestFactory extends ExecutionTestFactory {
    val classPath = System.getProperty("java.class.path").split(":").toList
  }

  /**
   * Testdata - a list with classname, expected error/warning count, a name for the test case, 
   * and if an exception is expected..
   */
  val testdata = List(
      ("ch.ethz.inf.sct.uts.examples.Casts",                         0, 0, "Casts",                   false),
      ("ch.ethz.inf.sct.uts.examples.InstanceOfTestsAndCasts",       0, 2, "InstanceOfTestsAndCasts", false),
      ("ch.ethz.inf.sct.uts.examples.RuntimeDefaulting",             0, 0, "RuntimeDefaulting",       false),
      ("ch.ethz.inf.sct.uts.examples.RuntimePlayground",             0, 0, "RuntimePlayground",       false),
      ("ch.ethz.inf.sct.uts.examples.ExternalsCasts",                0, 2, "ExternalsCasts",          false),
      (List(
          "ch.ethz.inf.sct.uts.examples.collection.stack.StackTest",
          "ch.ethz.inf.sct.uts.examples.collection.stack.Stack"
       ),                                                            0, 0, "StackTest",               false)
  )
  
  /**
   * Create a testsuite with the tests that should be executed.
   * @return the created testsuite.
   */
  def suite = {
    CompilationTestFactory.dynOptions = testArgs
    val suite = new TestSuite
    testdata foreach {
      case (cls: String, errors, warnings, name, exExpected) => 
        suite.addTest(CompilationTestFactory.produce(cls,errors,warnings,name))
        suite.addTest(ExecutionTestFactory.produce(cls,name,exExpected))
      case (cls: List[String], errors, warnings, name, exExpected) => 
        suite.addTest(CompilationTestFactory.produce(cls,errors,warnings,name))
        suite.addTest(ExecutionTestFactory.produce(cls.head,name,exExpected))
    }
    suite
  }
}