/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * 
 * $Id: DefaultTypeAbstraction.scala 817 2008-01-25 19:44:05Z ms $
 */
package ch.ethz.inf.sct.uts.plugin.staticcheck.rules.default

import scala.tools.nsc._
import ch.ethz.inf.sct.uts.plugin.staticcheck.common._

/**
 * Put together an abstraction from the Scala compiler's type representation for the 
 * default variant of the Universe type system.
 * 
 * @author  Manfred Stock
 * @version $Revision: 817 $
 */
trait DefaultTypeAbstraction[G <: Global] extends TypeAbstraction[G] 
                                             with DefaultUniverseTypeRepresentation[G] 
                                             with DefaultUTSMethodSignature[G]
                                             with DefaultOwnershipModifierExtender
