/*
 *              __  ____________        ____         __    
 *             / / / /_  __/ __/ ____  / __/______ _/ /__ _
 *            / /_/ / / / _\ \  /___/ _\ \/ __/ _ `/ / _ `/
 *            \____/ /_/ /___/       /___/\__/\_,_/_/\_,_/ 
 * 
 * This file is part of an implementation of the Universe Type System for
 * Scala.
 * 
 * Copyright (C) 2007-2008  Swiss Federal Institute of Technology, Zurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * 
 * $Id: StandardDefaults.scala 883 2008-02-01 18:59:56Z ms $
 */
package ch.ethz.inf.sct.uts.plugin.common.defaults

import ch.ethz.inf.sct.uts.annotation._

/**
 * Defaults for the static Universe type system checks and runtime checks.
 * 
 * @author  Manfred Stock
 * @version $Revision: 883 $
 */
class StandardDefaults extends UTSDefaults {
  /**
   * Names of methods which should be considered as pure.
   */
	def pureMethods = Map(
	    "java.lang.Object" -> List("equals","eq","ne","$bang$eq","$eq$eq"),
      "scala.Any"        -> List("$eq$eq","$bang$eq","isInstanceOf","asInstanceOf","eq","ne", "toString"),
      "scala.Predef"     -> List("println")
	)

  /**
   * Types which are immutable, in addition to the value types <code>Int</code>, 
   * <code>Boolean</code>, etc.
   */
  def immutableTypes = List(
      "java.lang.String",
      "scala.Null"
  )
  
  /**
   * Default ownership modifier for the upper bounds.
   */
  def ubOwnershipModifier = any()
  
  /**
   * Default ownership modifier for newly created objects and method parameters 
   * (if none has been specified explicitly) and fields/parameters/return
   * types from external (ie. not with this plugin compiled or from Java)
   * classes. 
   */
  def defaultOwnershipModifier = peer()
  
  /**
   * Default ownership modifier for immutable types.
   */
  def immutableDefaultOwnershipModifier = any()
  
  /**
   * Default ownership modifier for an <code>object</code> which is defined somewhere 
   * inside of a class, ie. not directly in a package.
   */
  def defaultInternalObjectOwnershipModifier = peer()
  
  /**
   * Default ownership modifier for an <code>object</code> which is defined 
   * directly in a package.
   */
  def defaultPackageObjectOwnershipModifier = any()
}
