/*
 * This file is part the Universe Runtime Classes.
 *
 * Copyright (C) 2003-2005 Swiss Federal Institute of Technology Zurich
 *
 * Part of mjc, the MultiJava Compiler.
 *
 * Copyright (C) 2000-2005 Iowa State University
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: UrtDummy.java,v 1.2 2005/06/28 20:56:08 wdietl Exp $
 */

package org.multijava.universes.rt.impl;

import org.multijava.universes.rt.UrtImplementation;

/**
 * Alternative implementation of UrtDefaultImplementation that does nothing.
 * 
 * Usefull to speed up universe programs without having to recompile it without
 * universe runtime check support.
 * 
 * @author scdaniel
 */
public class UrtDummy implements UrtImplementation {
	
    public void setOwnerRep (Object obj, Object owner) {}
    public void setOwnerPeer (Object obj, Object current) {}
    public void setConstructorData (Object currentObject, Object objectClass, int modifier) {}
    public void setOwner (Object o) {}
    public void setArrayOwnerRep (Object obj, Object owner, int arrayElementType) {}
    public void setArrayOwnerPeer (Object obj, Object current, int arrayElementType) {}
    public boolean isPeer (Object o1, Object o2) { return true; }
    public boolean isOwner (Object owner, Object obj) { return true; }
    public boolean checkArrayType (Object o, int elementType) { return true; }
    public Object getOwner (Object obj) { return null; }
    public Object getRootSetMember () { return null; }
    public void setContext (Object currentObject) {}
    public void resetContext () {}
    public Object getContext () { return null; }
}
