// $ANTLR 2.7.6 (2005-12-22): "Mjc.g" -> "MjcLexer.java"$
 
/*
 * Copyright (C) 2000-2004 Iowa State University
 *
 * This file is part of mjc, the MultiJava Compiler.
 *
 * based in part on work:
 *
 * Copyright (C) 1990-99 DMS Decision Management Systems Ges.m.b.H.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * $Id: Mjc.g,v 1.66 2006/12/13 20:59:34 wdietl Exp $
 */

/*
 * Grammar based on:
 * Java 1.2 Recognizer
 *
 * Contributing authors:
 *        John Mitchell        johnm@non.net
 *        Terence Parr        parrt@magelang.com
 *        John Lilley        jlilley@empathy.com
 *        Scott Stanchfield    thetick@magelang.com
 *        Markus Mohnen           mohnen@informatik.rwth-aachen.de
 *        Peter Williams        pwilliams@netdynamics.com
 *
 * Version 1.00 December 9, 1997 -- initial release
 * Version 1.01 December 10, 1997
 *        fixed bug in octal def (0..7 not 0..8)
 * Version 1.10 August 1998 (parrt)
 *        added tree construction
 *        fixed definition of WS,comments for mac,pc,unix newlines
 *        added unary plus
 * Version 1.11 (Nov 20, 1998)
 *        Added "shutup" option to turn off last ambig warning.
 *        Fixed inner class def to allow named class defs as statements
 *        synchronized requires compound not simple statement
 *        add [] after builtInType DOT class in primaryExpression
 *        "const" is reserved but not valid..removed from modifiers
 * Version 1.12 (Feb 2, 1999)
 *        Changed LITERAL_xxx to xxx in tree grammar.
 *        Updated java.g to use tokens {...} now for 2.6.0 (new feature).
 *
 * Version 1.13 (Apr 23, 1999)
 *        Didn't have (stat)? for else clause in tree parser.
 *        Didn't gen ASTs for interface extends.  Updated tree parser too.
 *        Updated to 2.6.0.
 * Version 1.14 (Jun 20, 1999)
 *        Allowed final/abstract on local classes.
 *        Removed local interfaces from methods
 *        Put instanceof precedence where it belongs...in relationalExpr
 *            It also had expr not type as arg; fixed it.
 *        Missing ! on SEMI in classBlock
 *        fixed: (expr) + "string" was parsed incorrectly (+ as unary plus).
 *        fixed: didn't like Object[].class in parser or tree parser
 * Version 1.15 (Jun 26, 1999)
 *        Screwed up rule with instanceof in it. :(  Fixed.
 *        Tree parser didn't like (expr).something; fixed.
 *        Allowed multiple inheritance in tree grammar. oops.
 * Version 1.16 (August 22, 1999)
 *        Extending an interface built a wacky tree: had extra EXTENDS.
 *        Tree grammar didn't allow multiple superinterfaces.
 *        Tree grammar didn't allow empty var initializer: {}
 *
 * The original grammar was in the PUBLIC DOMAIN
 *
 * BUGS
 *
 */

    // common parser/lexer header
    package org.multijava.mjc; 

    import org.multijava.util.compiler.*;
    import java.io.Reader;

public interface MjcTokenTypes {
	int EOF = 1;
	int NULL_TREE_LOOKAHEAD = 3;
	int LITERAL_abstract = 4;
	int LITERAL_assert = 5;
	int LITERAL_boolean = 6;
	int LITERAL_break = 7;
	int LITERAL_byte = 8;
	int LITERAL_case = 9;
	int LITERAL_catch = 10;
	int LITERAL_char = 11;
	int LITERAL_class = 12;
	int LITERAL_const = 13;
	int LITERAL_continue = 14;
	int LITERAL_default = 15;
	int LITERAL_do = 16;
	int LITERAL_double = 17;
	int LITERAL_else = 18;
	int LITERAL_extends = 19;
	int LITERAL_false = 20;
	int LITERAL_final = 21;
	int LITERAL_finally = 22;
	int LITERAL_float = 23;
	int LITERAL_for = 24;
	int LITERAL_goto = 25;
	int LITERAL_if = 26;
	int LITERAL_implements = 27;
	int LITERAL_import = 28;
	int LITERAL_instanceof = 29;
	int LITERAL_int = 30;
	int LITERAL_interface = 31;
	int LITERAL_long = 32;
	int LITERAL_native = 33;
	int LITERAL_new = 34;
	int LITERAL_null = 35;
	int LITERAL_package = 36;
	int LITERAL_private = 37;
	int LITERAL_protected = 38;
	int LITERAL_public = 39;
	int LITERAL_peer = 40;
	int LITERAL_readonly = 41;
	int LITERAL_rep = 42;
	int LITERAL_pure = 43;
	int LITERAL_resend = 44;
	int LITERAL_return = 45;
	int LITERAL_short = 46;
	int LITERAL_static = 47;
	int LITERAL_strictfp = 48;
	int LITERAL_super = 49;
	int LITERAL_switch = 50;
	int LITERAL_synchronized = 51;
	int LITERAL_this = 52;
	int LITERAL_throw = 53;
	int LITERAL_throws = 54;
	int LITERAL_transient = 55;
	int LITERAL_true = 56;
	int LITERAL_try = 57;
	int LITERAL_void = 58;
	int LITERAL_volatile = 59;
	int LITERAL_while = 60;
	int LITERAL__warn = 61;
	int LITERAL__warn_op = 62;
	int LITERAL__nowarn = 63;
	int LITERAL__nowarn_op = 64;
	int ASSIGN = 65;
	int AT = 66;
	int BAND = 67;
	int BAND_ASSIGN = 68;
	int BNOT = 69;
	int BOR = 70;
	int BOR_ASSIGN = 71;
	int BSR = 72;
	int BSR_ASSIGN = 73;
	int BXOR = 74;
	int BXOR_ASSIGN = 75;
	int COLON = 76;
	int COMMA = 77;
	int DEC = 78;
	int DOT = 79;
	int EQUAL = 80;
	int GE = 81;
	int GT = 82;
	int INC = 83;
	int LAND = 84;
	int LBRACK = 85;
	int LCURLY = 86;
	int LE = 87;
	int LNOT = 88;
	int LOR = 89;
	int LPAREN = 90;
	int LT = 91;
	int MINUS = 92;
	int MINUS_ASSIGN = 93;
	int NOT_EQUAL = 94;
	int PERCENT = 95;
	int PERCENT_ASSIGN = 96;
	int PLUS = 97;
	int PLUS_ASSIGN = 98;
	int QUESTION = 99;
	int RBRACK = 100;
	int RCURLY = 101;
	int RPAREN = 102;
	int SEMI = 103;
	int SL = 104;
	int SLASH = 105;
	int SLASH_ASSIGN = 106;
	int SL_ASSIGN = 107;
	int SR = 108;
	int SR_ASSIGN = 109;
	int STAR = 110;
	int STAR_ASSIGN = 111;
	int CHARACTER_LITERAL = 112;
	int IDENT = 113;
	int INTEGER_LITERAL = 114;
	int REAL_LITERAL = 115;
	int STRING_LITERAL = 116;
	int JAVADOC_OPEN = 117;
}
