package ch.ethz.inf.sct.uts.examples.collection.map

import ch.ethz.inf.sct.uts.annotation._

class MapIterImpl[K,V,X <: MapNode[K,V,X] @any] extends MapIter[K,V] {
  private var current_node: X = _

  def setCurrent(new_current: X) {
    current_node = new_current
  }

  @pure def getKey: K =	current_node.getKey

  @pure def getValue: V = current_node.getValue      

  @pure def hasNext: Boolean @any = current_node != null

  def next {
    current_node = current_node.getNext 
  }
}
