package ch.ethz.inf.sct.uts.examples.collection.map

import ch.ethz.inf.sct.uts.annotation._

class Map[K <: Comparable[K], V] {
  private var first: Node[K, V] @rep = _
        
  def put(key: K, value: V) {
    val newfirst : Node[K,V] @rep = new (Node[K, V] @rep)
    newfirst.init(key, value, first)
    first = newfirst
  }
        
  @pure def get(key: K) : Option[V] = {
    val iter = iterator
    while (iter.hasNext) {
      if (iter.getKey.equals(key)) {
        return Some(iter.getValue)
      }
      iter.next
    }
    return None
  }
            
  @pure def iterator : MapIter[K,V] = {
    val iter = new MapIterImpl[K,V,Node[K,V] @rep]
    iter.setCurrent(first)
    iter
  }
  
  def each(fun: (K,V) => unit) {
    val iter = iterator
    while (iter.hasNext) {
     fun(iter.getKey,iter.getValue)
     iter.next
    }
  }
}        
