/*
 * Decompiled with CFR 0.152.
 */
package org.multijava.universes.rt.impl;

import org.multijava.universes.rt.impl.UrtHashtableEntry;
import org.multijava.universes.rt.impl.UrtWeakReference;

public class UrtHashtable {
    private UrtHashtableEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public UrtHashtable() {
        int initialCapacity = 101;
        float loadFactor = 0.75f;
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new UrtHashtableEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public synchronized UrtHashtableEntry get(Object o) {
        int hash = System.identityHashCode(o);
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        UrtHashtableEntry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && e.holds(o)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized UrtHashtableEntry get(UrtWeakReference r) {
        int hash = r.hash;
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        UrtHashtableEntry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && e.obj == r) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        UrtHashtableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        UrtHashtableEntry[] newTable = new UrtHashtableEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            UrtHashtableEntry old = oldTable[i];
            while (old != null) {
                UrtHashtableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public synchronized UrtHashtableEntry put(Object o, UrtHashtableEntry e) {
        if (o == null || e == null) {
            throw new NullPointerException();
        }
        if (this.count >= this.threshold) {
            this.rehash();
        }
        int hash = System.identityHashCode(o);
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        UrtHashtableEntry i = this.table[index];
        while (i != null) {
            if (i.hash == hash && i.holds(o)) {
                return i;
            }
            i = i.next;
        }
        e.hash = hash;
        e.next = this.table[index];
        this.table[index] = e;
        ++this.count;
        return e;
    }

    public synchronized void remove(UrtHashtableEntry e) {
        int hash = e.hash;
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        UrtHashtableEntry i = this.table[index];
        UrtHashtableEntry prev = null;
        while (i != null) {
            if (i == e) {
                if (prev != null) {
                    prev.next = i.next;
                } else {
                    this.table[index] = i.next;
                }
                --this.count;
            }
            prev = i;
            i = i.next;
        }
    }
}

