/*
 * Decompiled with CFR 0.152.
 */
package org.multijava.universes.rt.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.multijava.universes.rt.UrtImplementation;
import org.multijava.universes.rt.impl.UrtDefaultImplementation;
import org.multijava.universes.rt.impl.UrtHashtable;

public class UrtVisualizer
extends UrtDefaultImplementation
implements UrtImplementation {
    FileWriter fw;
    PrintWriter pw;
    int counter = 0;

    public UrtVisualizer() throws IOException {
        String outfile = System.getProperty("UrtOutfile");
        if (outfile == null) {
            throw new IOException(UrtVisualizer.class.toString() + ": no outputfile defined!");
        }
        this.fw = new FileWriter(new File(outfile));
        this.pw = new PrintWriter(this.fw);
        this.pw.println("digraph UniverseRuntime {");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                UrtVisualizer.this.cleanup();
            }
        });
    }

    public String getName(Object o) {
        String hashCode = Integer.toString(System.identityHashCode(o));
        String clazz = o.getClass().getName();
        int index = clazz.lastIndexOf(".");
        if (index == -1) {
            return clazz + "@" + hashCode;
        }
        return clazz.substring(index + 1) + "@" + hashCode;
    }

    @Override
    public void setOwnerRep(Object obj, Object owner) {
        if (this.pw != null) {
            String ownerName = this.getName(owner);
            String objName = this.getName(obj);
            if (!(owner instanceof UrtHashtable)) {
                this.pw.println("\t\"" + ownerName + "\" -> \"" + objName + "\";");
            }
            this.pw.println("\t\"" + objName + "\"[label=\"" + this.counter++ + " - " + objName + "\"];");
            this.pw.println("\tsubgraph \"cluster" + ownerName + "\" {\"" + objName + "\";}");
            this.pw.flush();
        }
        super.setOwnerRep(obj, owner);
    }

    private void cleanup() {
        this.pw.println("}");
        this.pw.flush();
        try {
            this.fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

